package gov.va.med.domain.model;

/*import gov.va.med.domain.service.messaging.decode.MessageDecoder;
import gov.va.med.domain.service.messaging.encode.MessageEncoder;
import gov.va.med.domain.service.messaging.handler.IMessageHandler;
import gov.va.med.domain.service.messaging.handler.NoOpMessageHandler;
import gov.va.med.framework.util.ObjectFactory;*/

import gov.va.med.domain.service.messaging.decode.MessageDecoder;
import gov.va.med.domain.service.messaging.encode.MessageEncoder;

import java.util.Set;

import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="FUNCTIONS"
 *     
*/
public class Function extends DomainObject {

    /** persistent field */
    private String functionName;

    /** nullable persistent field */
    private String encoder;

    /** nullable persistent field */
    private String decoder;

    /** nullable persistent field */
    private String asyncDecoder;

    /** nullable persistent field */
    private String asyncHandler;

    /** nullable persistent field */
    private String aaEncoder;

    /** nullable persistent field */
    private PhrFunction phrFunction;

    /** persistent field */
    private CategoryType categoryType;

    /** persistent field */
    private Set patientMessagingRequests;

    /** persistent field */
    private Set messagingRequests;

    /** full constructor */
    public Function(Long id, String functionName, String encoder, String decoder, String asyncDecoder, String asyncHandler, String aaEncoder, gov.va.med.domain.model.PhrFunction phrFunction, gov.va.med.domain.model.CategoryType categoryType, Set patientMessagingRequests, Set messagingRequests) {
        this.setId(id);
        this.functionName = functionName;
        this.encoder = encoder;
        this.decoder = decoder;
        this.asyncDecoder = asyncDecoder;
        this.asyncHandler = asyncHandler;
        this.aaEncoder = aaEncoder;
        this.phrFunction = phrFunction;
        this.categoryType = categoryType;
        this.patientMessagingRequests = patientMessagingRequests;
        this.messagingRequests = messagingRequests;
    }

    /** default constructor */
    public Function() {
    }

    /** minimal constructor */
    public Function(Long id, String functionName, gov.va.med.domain.model.CategoryType categoryType, Set patientMessagingRequests, Set messagingRequests) {
        this.setId(id);
        this.functionName = functionName;
        this.categoryType = categoryType;
        this.patientMessagingRequests = patientMessagingRequests;
        this.messagingRequests = messagingRequests;
    }
    
    /** 
     *            @hibernate.property
     *             column="FUNCTION_NAME"
     *             update="false"
     *             insert="false"
     *             length="75"
     *             not-null="true"
     *         
     */
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    /** 
     *            @hibernate.property
     *             column="ENCODER"
     *             update="false"
     *             insert="false"
     *             length="240"
     *         
     */
    public String getEncoder() {
        return this.encoder;
    }

    public void setEncoder(String encoder) {
        this.encoder = encoder;
    }

    /** 
     *            @hibernate.property
     *             column="DECODER"
     *             update="false"
     *             insert="false"
     *             length="240"
     *         
     */
    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String decoder) {
        this.decoder = decoder;
    }

    /** 
     *            @hibernate.property
     *             column="ASYNC_DECODER"
     *             update="false"
     *             insert="false"
     *             length="240"
     *         
     */
    public String getAsyncDecoder() {
        return this.asyncDecoder;
    }

    public void setAsyncDecoder(String asyncDecoder) {
        this.asyncDecoder = asyncDecoder;
    }

    /** 
     *            @hibernate.property
     *             column="ASYNC_HANDLER"
     *             update="false"
     *             insert="false"
     *             length="240"
     *         
     */
    public String getAsyncHandler() {
        return this.asyncHandler;
    }

    public void setAsyncHandler(String asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    /** 
     *            @hibernate.property
     *             column="AA_ENCODER"
     *             update="false"
     *             insert="false"
     *             length="240"
     *         
     */
    public String getAaEncoder() {
        return this.aaEncoder;
    }

    public void setAaEncoder(String aaEncoder) {
        this.aaEncoder = aaEncoder;
    }

    /** 
     *            @hibernate.one-to-one
     *             outer-join="auto"
     *         
     */
    public gov.va.med.domain.model.PhrFunction getPhrFunction() {
        return this.phrFunction;
    }

    public void setPhrFunction(gov.va.med.domain.model.PhrFunction phrFunction) {
        this.phrFunction = phrFunction;
    }

    /** 
     *            @hibernate.many-to-one
     *             not-null="true"
     *            @hibernate.column name="CATEGORY_CODE"         
     *         
     */
    public gov.va.med.domain.model.CategoryType getCategoryType() {
        return this.categoryType;
    }

    public void setCategoryType(gov.va.med.domain.model.CategoryType categoryType) {
        this.categoryType = categoryType;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="FUNCTION_ID_SEQ"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.PatientMessagingRequest"
     *         
     */
    public Set getPatientMessagingRequests() {
        return this.patientMessagingRequests;
    }

    public void setPatientMessagingRequests(Set patientMessagingRequests) {
        this.patientMessagingRequests = patientMessagingRequests;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="FUNCTION_ID_SEQ"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.MessagingRequest"
     *         
     */
    public Set getMessagingRequests() {
        return this.messagingRequests;
    }

    public void setMessagingRequests(Set messagingRequests) {
        this.messagingRequests = messagingRequests;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .append("functionName", getFunctionName())
            .append("encoder", getEncoder())
            .append("decoder", getDecoder())
            .append("asyncDecoder", getAsyncDecoder())
            .append("asyncHandler", getAsyncHandler())
            .append("aaEncoder", getAaEncoder())
            .toString();
    }
    
	public MessageEncoder getEncoderInstance() {
		//return (MessageEncoder) ObjectFactory.loadAndCreateClass(getEncoder());
		//TODO: revisit and fix it
		String s = getEncoder();
		return null;
	}

	public MessageEncoder getAaEncoderInstance() {
		//return (MessageEncoder) ObjectFactory.loadAndCreateClass(getAaEncoder());
		//TODO: revisit and fix it
		String s = getAaEncoder();
		return null;
	}

	public MessageDecoder getDecoderInstance() {
		//return (MessageDecoder) ObjectFactory.loadAndCreateClass(getAaEncoder());
		//TODO: revisit and fix it
		String s = getAaEncoder();
		return null;
	}

	public MessageDecoder getAsynchDecoderInstance() {
		//return (MessageDecoder) ObjectFactory.loadAndCreateClass(getAaEncoder());
		//TODO: revisit and fix it
		String s = getAaEncoder();
		return null;
	}
	
    /**
     * The actual column value may not be a single bean name but a comma delimited list of names.
     * PLEASE:  Use the getAsyncHandlerInstances to get the array of handlers built from this list so as to
     * be able to invoke them in sequence to handle the message.
     * 
     * @return the column value for Handler which now can be a comma delimited ordered list 
     * of handlers to invoke to handle the message.  
     * 
     *//*
    public IMessageHandler getHandlerInstance() 
    {	
        if (getAsyncHandler() == null){
//            logger.error("No IMessageHandler specified for function [" + 
//                    	  getRemoteFunctionName()+ "], substituting NoOpMessageHandler" + '\n');		
            return new NoOpMessageHandler();
        }
        return obtainHandlerInstance(getAsyncHandler());
    }
    *//** 
     * Prepares an array of handlers built from the bean names the comma delimited list 
     * in the AsyncHandler column. 
     *//*
    public IMessageHandler[] getHandlerInstances() {
        StringTokenizer handlerNames = new StringTokenizer(getAsyncHandler(), ","); 
        IMessageHandler [] handlers = new IMessageHandler[handlerNames.countTokens()];
        int i = 0;
        while (handlerNames.hasMoreTokens()) {
            handlers[i] = obtainHandlerInstance(handlerNames.nextToken());
            i++;
        }
        return handlers;
    }
    protected IMessageHandler obtainHandlerInstance(String name) {
        return (IMessageHandler) ObjectFactory.loadAndCreateClass(getAsyncHandler());
    }*/
}
